
function [neff] = saitoh_w2neff(w,pitch,dpr)

% See Saitoh & Koshiba (2005) - Empirical Relations for Simple Design of Photonic Crystal Fibers
wl = 2*pi*3e8./(w.*1e-6);
wlpr = wl./pitch; 

%Fitting Coefficients (Eqn.6 Saitoh(2005)) ai0 == ai4 == a(i,4)
a = [5.00401 -10.43248 8.22992 0.54808;9.73491 47.41496 -437.50962 0.71041; ...
    1.85765 18.96849 -42.4318 0.16904; 1.06745 1.93229 3.89 -1.52736];
b = [5 7 9; 1.8 7.32 22.8; 1.7 10 14; -0.84 1.02 13.4];
c = [-16.70566 67.13845 -50.25518 -0.0973; ...
    6.70858 52.04855 -540.66947 0.53193;...
    2.72423 13.28649 -36.80372 0.24876;...
    0.05142 -5.18302 2.7641 5.29801];
d = [7 9 10;1.49 6.58 24.8; 3.85 10 15; -2 0.41 6]; 

[A,B] = deal(zeros(1,4)); %Prealocate

for i = 1:4
    A(i) = a(i,4) + a(i,1)*(dpr)^b(i,1) + a(i,2)*(dpr)^b(i,2) + ...
           a(i,3)*(dpr)^b(i,3); %Eqn.6
    B(i) = c(i,4) + c(i,1)*(dpr)^d(i,1) + c(i,2)*(dpr)^d(i,2) + ...
           c(i,3)*(dpr)^d(i,3); %Eqn.8          
end

[V,W] = deal(zeros(length(w)));

V = A(1)+(A(2))./(1 +A(3) .* exp(A(4) .* wlpr)); %Eqn.5
W = B(1)+(B(2))./(1 +B(3) .* exp(B(4) .* wlpr)); %Eqn.7

% Calculate n_eff(V,W,Wavelength,Pitch)
neff=zeros(size(w));
for t = 1:length(w)
    neff(:,t) = ((nsilica_array(wl(:,t))).^2 - (((V(:,t).^2 -W(:,t).^2).^0.5).*(wlpr(:,t)).*(sqrt(3))/(2.*pi)).^2).^0.5;%Eqn.1
end
end